/* 
Veidotājs: Roberts Blite
Mērķis: Šis skripts pārvalda FAQ sadaļas funkcionalitāti - ielādēšanu, pievienošanu, rediģēšanu un dzēšanu.
Apraksts: Skripts izmanto fetch API, lai veiktu AJAX pieprasījumus uz serveri, pārvaldot FAQ datus.
*/

// Gaida, līdz lapa ir pilnībā ielādēta, un pēc tam izsauc loadFAQs()
document.addEventListener("DOMContentLoaded", loadFAQs);

// Funkcija, lai ielādētu FAQ datus no servera
function loadFAQs() {
    fetch("../php/faq.php?action=read") // Pieprasījums FAQ datu iegūšanai
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP kļūda! Statuss: ${response.status}`);
            }
            return response.json(); // Konvertē atbildi JSON formātā
        })
        .then(data => {
            if (data.error) {
                console.error("Kļūda, iegūstot FAQ:", data.error);
                return;
            }

            // Iegūst tabulas body elementu un attīra to
            const faqBody = document.getElementById("faq-body");
            faqBody.innerHTML = "";

            // Caur katru FAQ ierakstu veido jaunu tabulas rindu
            data.forEach(faq => {
                const row = document.createElement("tr");

                // Jautājuma kolonna
                const questionCell = document.createElement("td");
                questionCell.textContent = faq.question;
                row.appendChild(questionCell);

                // Atbildes kolonna
                const answerCell = document.createElement("td");
                answerCell.textContent = faq.answer;
                row.appendChild(answerCell);

                // Opciju (rediģēt un dzēst) kolonna
                const optionsCell = document.createElement("td");

                // Rediģēšanas poga
                const editButton = document.createElement("button");
                editButton.textContent = "Rediģēt";
                editButton.onclick = () => editFAQ(faq.id, faq.question, faq.answer);

                // Dzēšanas poga
                const deleteButton = document.createElement("button");
                deleteButton.textContent = "Dzēst";
                deleteButton.onclick = () => deleteFAQ(faq.id);

                // Pievieno pogas pie opciju kolonnas
                optionsCell.appendChild(editButton);
                optionsCell.appendChild(deleteButton);
                row.appendChild(optionsCell);

                // Pievieno rindu tabulas body
                faqBody.appendChild(row);
            });
        })
        .catch(error => console.error("Kļūda, iegūstot FAQ:", error));
}

// Funkcija, lai pievienotu jaunu jautājumu un atbildi
function addNewFAQ() {
    const question = prompt("Ievadiet savu jautājumu:");
    const answer = prompt("Ievadiet savu atbildi:");

    if (question && answer) {
        fetch("../php/faq.php?action=create", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ question, answer }) // Nosūta jauno jautājumu serverim
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP kļūda! Statuss: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    loadFAQs(); // Pēc pievienošanas atkārtoti ielādē FAQ
                } else {
                    console.error("Kļūda, pievienojot FAQ:", data.error);
                }
            })
            .catch(error => console.error("Kļūda, pievienojot FAQ:", error));
    }
}

// Funkcija, lai rediģētu esošu jautājumu un atbildi
function editFAQ(id, currentQuestion, currentAnswer) {
    const question = prompt("Rediģējiet jautājumu:", currentQuestion);
    const answer = prompt("Rediģējiet atbildi:", currentAnswer);

    if (question && answer) {
        fetch("../php/faq.php?action=update", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ id, question, answer }) // Nosūta atjaunināto saturu serverim
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP kļūda! Statuss: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    loadFAQs(); // Pēc rediģēšanas atkārtoti ielādē FAQ
                } else {
                    console.error("Kļūda, rediģējot FAQ:", data.error || "Nezināma kļūda");
                }
            })
            .catch(error => console.error("Kļūda, rediģējot FAQ:", error));
    }
}

// Funkcija, lai dzēstu esošu jautājumu un atbildi
function deleteFAQ(id) {
    if (confirm("Vai tiešām vēlaties dzēst šo FAQ?")) {
        fetch(`../php/faq.php?action=delete&id=${id}`, {
            method: "GET" // GET metode tiek izmantota, jo serveris izmanto pieprasījuma parametrus
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP kļūda! Statuss: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    loadFAQs(); // Pēc dzēšanas atkārtoti ielādē FAQ
                } else {
                    console.error("Kļūda, dzēšot FAQ:", data.error || "Nezināma kļūda");
                }
            })
            .catch(error => console.error("Kļūda, dzēšot FAQ:", error));
    }
}
